VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsCCTextAutocomplete"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Compare Database
Option Explicit

'---------------------------------------------------------------------------------------
' Module      : clsCCTextAutocomplete
' Version     : V1.0
' Author      : Christian Coppes
' Date        : 21.04.2012
' Last Change : 21.04.2012
' Purpose     : Textbox wie eine Combobox mit Autocomplete verwenden
'---------------------------------------------------------------------------------------

' ######################################################################################
' --------------------------------------------------------------------------------------
' -------------------------------------- Constants -------------------------------------
' --------------------------------------------------------------------------------------
' ######################################################################################

Private Const cMODULENAME As String = "clsCCTextAutocomplete"
Private Const cEventProcedure As String = "[Event Procedure]"

' verwendete Einstellungen fr die Funktion "fnSearchInput"
Private Enum fnSIMode
    fnSIOpen = 0
    fnSIClose = 1
    fnSISearch = 2
End Enum

Public Enum EnmErrorsCCAutoComplete
    enmErrorsCCAutoComplete_UseInitAutoCompleteFirst
    enmErrorsCCAutoComplete_MissingAutoCompleteTextboxReference
    enmErrorsCCAutoComplete_MissingTableName
    enmErrorsCCAutoComplete_MissingIDFieldName
    enmErrorsCCAutoComplete_MissingTextFieldName
    enmErrorsCCAutoComplete_WrongTableName
    enmErrorsCCAutoComplete_WrongIDFieldName
    enmErrorsCCAutoComplete_WrongTextFieldName
    enmErrorsCCAutoComplete_AddTB_MissingTextboxReference
    enmErrorsCCAutoComplete_AddTB_MissingFieldName
    enmErrorsCCAutoComplete_AddTB_WrongFieldName
    enmErrorsCCAutoComplete_AddTB_TextboxAlreadyInserted
    enmErrorsCCAutoComplete_AddTB_NotAnUnboundTextbox
    enmErrorsCCAutoComplete_AddTB_TextboxEqualToACTextbox
    enmErrorsCCAutoComplete_ErrorNumberDoesntExist
    enmErrorsCCAutoComplete_Last
End Enum

' Deutsche Fehlermeldungen
Private Const cError_UseInitAutoCompleteFirst_DE                As String = "Bitte zuerst die ""InitAutoComplete""-Sub verwenden, bevor eine zustzliche Textbox hinzugefgt werden kann!"
Private Const cError_MissingAutoCompleteTextboxReference_DE     As String = "Fehlende Referenz zur Textbox, die fr AutoComplete verwendet werden soll!"
Private Const cError_MissingTableName_DE                        As String = "Fehlender Tabellen- bzw. Abfragename!"
Private Const cError_MissingIDFieldName_DE                      As String = "Fehlender Feldname des Feldes, das die ID enthlt!"
Private Const cError_MissingTextFieldName_DE                    As String = "Fehlender Feldname des Feldes, das den Text enthlt, der in der AutoComplete-Textbox angezeigt werden soll!"
Private Const cError_WrongTableName_DE                          As String = "Tabellen-/Abfragename existiert nicht in der Datenbank!"
Private Const cError_WrongIDFieldName_DE                        As String = "Name des ID-Feldes existiert nicht in der Tabelle/Abfrage"
Private Const cError_WrongTextFieldName_DE                      As String = "Name des Textfeldes existiert nicht in der Tabelle/Abfrage"
Private Const cError_AddTB_MissingTextboxReference_DE           As String = "Fehlende Referenz zur Textbox, die zustzlich zur AutoComplete-Textbox verwendet werden soll!"
Private Const cError_AddTB_MissingFieldName_DE                  As String = "Fehlender Feldname fr das Feld, das in der zustzlichen Textbox angezeigt werden soll!"
Private Const cError_AddTB_WrongFieldName_DE                    As String = "Der Feldname existiert nicht in der Tabelle/Abfrage!"
Private Const cError_AddTB_TextboxAlreadyInserted_DE            As String = "Diese Textbox wurde bereits eingefgt!"""
Private Const cError_AddTB_NotAnUnboundTextbox_DE               As String = "Diese Textbox ist nicht ungebunden, kann nicht als zustzliche Textbox fr die Autocomplete-Textbox verwendet werden!"
Private Const cError_AddTB_TextboxEqualToACTextbox_DE           As String = "Es kann nicht die gleiche Textbox/der gleiche Feldname als zustzliche Textbox verwendet werden, die bereits fr die AutoComplete-Textbox verwendet wurde!"
Private Const cError_ErrorNumberDoesntExist_DE                  As String = "Diese Fehlernummer existiert nicht in dieser Klasse!"

' Englische Fehlermeldungen
Private Const cError_UseInitAutoCompleteFirst_EN                As String = "Please use the ""InitAutoComplete"" sub first before you can add an additional textbox!"
Private Const cError_MissingAutoCompleteTextboxReference_EN     As String = "Missing reference to the textbox which should be used for autocomplete!"
Private Const cError_MissingTableName_EN                        As String = "Missing table/query name!"
Private Const cError_MissingIDFieldName_EN                      As String = "Missing fieldname of the field containing the ID!"
Private Const cError_MissingTextFieldName_EN                    As String = "Missing fieldname of the field containing the text to display in the autocomplete textbox!"
Private Const cError_WrongTableName_EN                          As String = "Table/Query name doesn't exist in the database!"
Private Const cError_WrongIDFieldName_EN                        As String = "ID fieldname doesn't exist in the table/query!"
Private Const cError_WrongTextFieldName_EN                      As String = "Text fieldname doesn't exist in the table/query!"
Private Const cError_AddTB_MissingTextboxReference_EN           As String = "Missing reference to the textbox which should additionally be used for the autocomplete textbox!"
Private Const cError_AddTB_MissingFieldName_EN                  As String = "Missing fieldname of the field which should be used to be displayed in the additional textbox!"
Private Const cError_AddTB_WrongFieldName_EN                    As String = "The fieldname doesn't exist in the table/query !"
Private Const cError_AddTB_TextboxAlreadyInserted_EN            As String = "This textbox was already inserted!"
Private Const cError_AddTB_NotAnUnboundTextbox_EN               As String = "The textbox is not an unbound textbox, cannot be used as additional textbox for the autocomplete textbox!"
Private Const cError_AddTB_TextboxEqualToACTextbox_EN           As String = "Cannot use the same textbox/fieldname as additional textbox which is also used as autocomplete textbox!"
Private Const cError_ErrorNumberDoesntExist_EN                  As String = "This error number doesn't exist in this class!"

Public Enum EnmCCAutoCompleteLanguage
    enmCCAutoCompleteLanguage_DE
    enmCCAutoCompleteLanguage_EN
End Enum

' ######################################################################################
' --------------------------------------------------------------------------------------
' ----------------------------------- Class Variables ----------------------------------
' --------------------------------------------------------------------------------------
' ######################################################################################

Private WithEvents prv_ctlTextbox As Access.TextBox
Attribute prv_ctlTextbox.VB_VarHelpID = -1
Private prv_strTableOrQuery As String
Private prv_strIDFieldName As String
Private prv_strTextFieldName As String
Private prv_strWhere As String
Private prv_rsSearch As DAO.Recordset
Private prv_varOldValue As Variant       ' fr ungebundene Textboxen notwendig
Private prv_colAdditionalFields As Collection
Private prv_colAdditionalFields_Names As Collection
Private prv_intLanguage As EnmCCAutoCompleteLanguage
Private prv_strErrors_DE() As String
Private prv_strErrors_EN() As String
Private prv_strSQL As String
Private prv_bolIsTable As Boolean

' ######################################################################################
' --------------------------------------------------------------------------------------
' -------------------------------------- Properties -------------------------------------
' --------------------------------------------------------------------------------------
' ######################################################################################

'---------------------------------------------------------------------------------------
' Property    : Language
' Access Meth.: Read/Write
' Date        : 21.04.2012
' Last Change : 21.04.2012
' Purpose     : Sprache der Fehlermeldungen einstellen
' Parameters  : Eine der Sprachen aus der Enum EnmCCAutoCompleteLanguage
' Returns     : enm - EnmCCAutoCompleteLanguage
'---------------------------------------------------------------------------------------
'
Public Property Get Language() As EnmCCAutoCompleteLanguage
    Language = prv_intLanguage
End Property
Public Property Let Language(ByVal intLanguage As EnmCCAutoCompleteLanguage)
    prv_intLanguage = intLanguage
End Property

' ######################################################################################
' --------------------------------------------------------------------------------------
' -------------------------------------- Methods ---------------------------------------
' --------------------------------------------------------------------------------------
' ######################################################################################

'---------------------------------------------------------------------------------------
' Procedure   : InitAutoComplete
' Date        : 21.04.2012
' Last Change : 21.04.2012
' Purpose     : AutoComplete-Textbox initialisieren
' Parameters  : ctlTextbox: Name der AutoComplete-Textbox
'               strTableOrQuery: Name einer Tabelle oder Abfrage
'               strIDFieldName: Name des Feldes in der Tabelle/Abfrage, das die ID enthlt
'               strTextFieldName: Name des Feldes, das den Text enthlt, der mit AutoComplete
'                                 gesucht werden soll
'               strWhere: Zustzliche WHERE-Bedingung
' Returns     :  -
'---------------------------------------------------------------------------------------
'
Public Sub InitAutoComplete(ByRef ctlTextbox As Access.TextBox, ByVal strTableOrQuery As String, _
                            ByVal strIDFieldName As String, ByVal strTextFieldName As String, _
                            Optional ByRef ctlIDTextbox As Access.TextBox, _
                            Optional ByVal strWhere As String = "")
    Const cSource As String = cMODULENAME & "->InitAutoComplete"
    
    Dim db As DAO.Database
    Dim td As DAO.TableDef
    Dim strDummy As String
    
    If ctlTextbox Is Nothing Then RaiseError enmErrorsCCAutoComplete_MissingAutoCompleteTextboxReference, cSource
    If strTableOrQuery = "" Then RaiseError enmErrorsCCAutoComplete_MissingTableName, cSource
    If strIDFieldName = "" Then RaiseError enmErrorsCCAutoComplete_MissingIDFieldName, cSource
    If strTextFieldName = "" Then RaiseError enmErrorsCCAutoComplete_MissingTextFieldName, cSource
    
    If fnTestTableOrQuery(strTableOrQuery, cSource) Then
        If fnTestField(strTableOrQuery, strIDFieldName, cSource) = False Then
            On Error GoTo 0
            RaiseError enmErrorsCCAutoComplete_WrongIDFieldName, cSource
        End If
        If fnTestField(strTableOrQuery, strTextFieldName, cSource) = False Then
            On Error GoTo 0
            RaiseError enmErrorsCCAutoComplete_WrongTextFieldName, cSource
        End If
    End If
    
    Set prv_ctlTextbox = ctlTextbox
    With prv_ctlTextbox
        .OnGotFocus = cEventProcedure
        .OnLostFocus = cEventProcedure
        .OnKeyUp = cEventProcedure
    End With
    
    prv_strTableOrQuery = strTableOrQuery
    prv_strIDFieldName = strIDFieldName
    prv_strTextFieldName = strTextFieldName
    prv_strWhere = strWhere
    
    If Not ctlIDTextbox Is Nothing Then
        Me.AddTextbox ctlIDTextbox, strIDFieldName
    End If
        
    GetSQLString
End Sub

'---------------------------------------------------------------------------------------
' Procedure   : AddTextbox
' Date        : 21.04.2012
' Last Change : 21.04.2012
' Purpose     : Fgt die Referenz zu einer weiteren Textbox hinzu, die als Inhalt den
'               Inhalt des angegebenen Feldes aus der gleichen Tabelle/Query anzeigt
' Parameters  : ctlTextbox: Zustzliche ungebundene Textbox
'               strFieldname: Name eines Feldes in der Tabelle oder Query, das in dieser
'                             Textbox angezeigt werden soll, wenn die Autocomplete-Textbox
'                             einen Wert gefunden hat
' Returns     :  -
'---------------------------------------------------------------------------------------
'
Public Sub AddTextbox(ByRef ctlTextbox As Access.TextBox, strFieldName As String)
    Const cSource As String = cMODULENAME & "->AddTextbox"
        
    Dim ctl As Access.Control
    
    If prv_ctlTextbox Is Nothing Then RaiseError enmErrorsCCAutoComplete_UseInitAutoCompleteFirst, cSource
    If ctlTextbox Is Nothing Then RaiseError enmErrorsCCAutoComplete_AddTB_MissingTextboxReference, cSource
    If strFieldName = "" Then RaiseError enmErrorsCCAutoComplete_AddTB_MissingFieldName, cSource
    If fnTestField(prv_strTableOrQuery, strFieldName, cSource) = False Then RaiseError enmErrorsCCAutoComplete_AddTB_WrongFieldName, cSource
    If ctlTextbox.ControlSource <> "" Then RaiseError enmErrorsCCAutoComplete_AddTB_NotAnUnboundTextbox, cSource
    If prv_ctlTextbox Is ctlTextbox Or strFieldName = prv_strTextFieldName Then RaiseError enmErrorsCCAutoComplete_AddTB_TextboxEqualToACTextbox, cSource
    
    If prv_colAdditionalFields Is Nothing Then Set prv_colAdditionalFields = New Collection
    If prv_colAdditionalFields.Count > 0 Then
        For Each ctl In prv_colAdditionalFields
            If ctl.Name = ctlTextbox.Name Then RaiseError enmErrorsCCAutoComplete_AddTB_TextboxAlreadyInserted, cSource
        Next
    End If

    prv_colAdditionalFields.Add ctlTextbox, strFieldName
    prv_colAdditionalFields_Names.Add "[" & strFieldName & "]", strFieldName
    GetSQLString
End Sub

'---------------------------------------------------------------------------------------
' Procedure   : ErrText
' Date        : 21.04.2012
' Last Change : 21.04.2012
' Purpose     : Fehlertext der zugehrigen Fehlernummer in der passenden Sprache ausgeben
' Parameters  : lngErrNumber: Eine der Fehlernummern aus der Enumeration EnmErrorsCCAutoComplete
'               intLanguage: Eine der verfgbaren Sprachen aus EnmCCAutoCompleteLanguage,
'                            wird keine angegeben, wird die zuvor eingestellte Sprache in prv_intLanguage
'                            verwendet
' Returns     : str - String
'---------------------------------------------------------------------------------------
'
Public Function ErrText(lngErrNumber As EnmErrorsCCAutoComplete, _
                        Optional ByVal intLanguage As EnmCCAutoCompleteLanguage = -1) As String
    Const cSource As String = cMODULENAME & "->ErrText"
    
    If intLanguage = -1 Then intLanguage = prv_intLanguage
    
    Select Case intLanguage
        Case enmCCAutoCompleteLanguage_EN
            If lngErrNumber < 0 Or lngErrNumber >= enmErrorsCCAutoComplete_Last Then
                ErrText = prv_strErrors_EN(enmErrorsCCAutoComplete_ErrorNumberDoesntExist)
            Else
                ErrText = prv_strErrors_EN(lngErrNumber)
            End If
        Case enmCCAutoCompleteLanguage_DE
            If lngErrNumber < 1 Or lngErrNumber >= enmErrorsCCAutoComplete_Last Then
                ErrText = prv_strErrors_DE(enmErrorsCCAutoComplete_ErrorNumberDoesntExist)
            Else
                ErrText = prv_strErrors_DE(lngErrNumber)
            End If
    End Select
End Function

'---------------------------------------------------------------------------------------
' Procedure   : fnTestTableOrQuery
' Date        : 21.04.2012
' Last Change : 21.04.2012
' Purpose     : Testet, ob der Name in der TableDefs- oder QueryDefs-Auflistung existiert
'               und setzt ein Flag, wenn es eine Tabelle ist
' Parameters  : strTableOrQuery : Name einer Tabelle oder Abfrage
'               strSource: ErrorSource-Name der aufrufenden Funktion fr Fehlerausgaben
' Returns     : bol - Boolean
'---------------------------------------------------------------------------------------
'
Private Function fnTestTableOrQuery(strTableOrQuery As String, strSource As String) As Boolean
    Dim db As DAO.Database
    Dim td As DAO.TableDef
    Dim qd As DAO.QueryDef
    
    fnTestTableOrQuery = False
    Set db = CurrentDb
    On Error Resume Next
    Set td = db.TableDefs(strTableOrQuery)
    If Err.Number <> 0 Then
        Err.Clear
        Set qd = db.QueryDefs(strTableOrQuery)
        If Err.Number <> 0 Then On Error GoTo 0: RaiseError enmErrorsCCAutoComplete_WrongTableName, strSource
        prv_bolIsTable = False
    Else
        prv_bolIsTable = True
    End If
    fnTestTableOrQuery = True
    On Error GoTo 0
    Set td = Nothing
    Set qd = Nothing
    Set db = Nothing
End Function

'---------------------------------------------------------------------------------------
' Procedure   : fnTestField
' Date        : 21.04.2012
' Last Change : 21.04.2012
' Purpose     : Testet, ob der Feldname aus strFieldName in der Tabelle oder Abfrage existiert
' Parameters  : strTableOrQuery: Name der Tabelle oder Abfrage
'               strFieldName: Name des Feldes
'               strSource: ErrorSource-Name der aufrufenden Funktion fr Fehlerausgaben
' Returns     : bol - Boolean
'---------------------------------------------------------------------------------------
'
Private Function fnTestField(strTableOrQuery As String, strFieldName As String, strSource As String) As Boolean
    Dim db As DAO.Database
    Dim TOrQ As Object
    Dim qd As DAO.QueryDef
    Dim strDummy As String
    
    If fnTestTableOrQuery(strTableOrQuery, strSource) Then
        Set db = CurrentDb
        If prv_bolIsTable Then
            Set TOrQ = db.TableDefs(strTableOrQuery)
        Else
            Set TOrQ = db.QueryDefs(strTableOrQuery)
        End If
        
        On Error Resume Next
        strDummy = TOrQ.Fields(strFieldName).Name
        If Err.Number <> 0 Then
            Err.Clear
            fnTestField = False
        Else
            fnTestField = True
        End If
        Set TOrQ = Nothing
        Set db = Nothing
    End If
End Function

'---------------------------------------------------------------------------------------
' Procedure   : GetSQLString
' Date        : 21.04.2012
' Last Change : 21.04.2012
' Purpose     : Stellt aus den Feldnamen den SQL-String zusammen, der fr die AutoComplete-
'               Funktion bentigt wird
' Parameters  : -
' Returns     : -
'---------------------------------------------------------------------------------------
'
Private Sub GetSQLString()
    Dim varFieldName As Variant
    prv_strSQL = "SELECT [" & prv_strIDFieldName & "],[" & prv_strTextFieldName & "]"
    
    If Not prv_colAdditionalFields_Names Is Nothing Then
        If prv_colAdditionalFields_Names.Count > 0 Then
            prv_strSQL = prv_strSQL & ","
            For Each varFieldName In prv_colAdditionalFields_Names
                prv_strSQL = prv_strSQL & varFieldName & ","
            Next
            Mid$(prv_strSQL, Len(prv_strSQL)) = " "
        End If
    End If
    prv_strSQL = prv_strSQL & "  FROM [" & prv_strTableOrQuery & "] " & _
                 IIf(prv_strWhere <> "", " WHERE " & prv_strWhere, "") & _
                 " ORDER BY [" & prv_strTextFieldName & "]"
End Sub

'---------------------------------------------------------------------------------------
' Procedure   : fnSearchInput
' Date        : 21.04.2012
' Last Change : 21.04.2012
' Purpose     : Ersatz der Dropdownliste mit einer Textbox
'               Funktioniert wie das automatische Ersetzen eines Eingabetextes in einer
'               Dropdownliste, nur als Textfeld
' Parameters  : txt = Textfeld, dessen Tastatureingaben berwacht werden sollen
'               strIDField  = Name des Feldes, dessen Wert zurckgegeben werden soll
'               strTxtField = Name des Feldes, dessen Wert in der Textbox angezeigt werden soll
'               strTable    = Name der Tabelle, die ausgelesen werden soll
'               KeyCode, Shift = Werte aus dem KeyUp-Event der Textbox (dort mu diese
'                                Funktion hier aufgerufen werden)
'               intMode     = Modus, 0=ffnen des Recordsets, 1 = Schliessen, 2= Suche durchfhren
'               strOrderBy,strWhere = Optionale Zustze zum SQL-String
' Returns     : var - Variant
'---------------------------------------------------------------------------------------
'
Private Function fnSearchInput(ByRef KeyCode As Integer, _
                               ByRef Shift As Integer, _
                               Optional ByVal strWhere As String = "") As Variant
    Const cSource As String = cMODULENAME & "->fnSearchInput"
    
    Dim strSearch As String
    Dim varFound As Variant
    Dim lngID As Long
    Dim lngStart As Long
    Dim strSQL As String
    Static varOldValue As Variant

   On Error GoTo fnSearchInput_Error

    lngID = 0
    
    ' Cursorposition speichern
    lngStart = prv_ctlTextbox.SelStart


    With prv_ctlTextbox
        Select Case KeyCode
            ' Esc
            Case 27
                .Value = varOldValue
                lngID = -1
                GoTo fnSearchInput_Exit  ' ------------->
            ' BS, Del, Tab
            Case 8, 46, 16, 9
                lngID = -1
                GoTo fnSearchInput_Exit  ' ------------->
            ' Pos1, End
            Case 36, 35
                If Shift = 0 Then
                    .SelLength = 0
                End If
                lngID = -1
                GoTo fnSearchInput_Exit  ' ------------->
            ' Cursor Left, Right
            Case 37, 39
                If Shift = 0 Then
                    .SelLength = 0
                End If
                lngID = -1
                GoTo fnSearchInput_Exit  ' ------------->
            Case Else
        End Select
    
        ' Textfeld ist leer, dann nichts tun
        If Nz(.Text) = "" Then GoTo fnSearchInput_Exit  ' ------------->
                
        ' Steht der Cursor irgendwo im Text?
        If .SelLength = 0 And .SelStart < Len(.Text) Then
            ' dann gesamten Text zur Suche verwenden
            strSearch = .Text
        Else
            ' ansonsten nur den nicht markierten Teil
            strSearch = Left(.Text, .SelStart)
            ' strSearch="", wenn der gesamte Text markiert ist,
            ' dann den gesamten Text als Suchtext verwenden
            If strSearch = "" Then
                strSearch = .Text
                ' ...und Markierung entfernen
                .SelStart = 0
                .SelLength = 0
            End If
        End If
    
        ' Suche durchfhren
        If Not (prv_rsSearch.EOF And prv_rsSearch.BOF) And Not Nz(strSearch) = "" Then
            prv_rsSearch.MoveFirst
            prv_rsSearch.FindFirst prv_strTextFieldName & " LIKE '" & strSearch & "*'"
            If prv_rsSearch.NoMatch Then
                varFound = ""
                lngID = 0
            Else
                varFound = CStr(Nz(prv_rsSearch.Fields(prv_strTextFieldName)))
                lngID = CLng(Nz(prv_rsSearch.Fields(prv_strIDFieldName), 0))
            End If
        Else
            varFound = ""
            lngID = 0
        End If
                    
        ' Wurde etwas gefunden?
        If varFound <> "" Then
            ' Ist die Lnge des gefundenen Textes grer als
            ' die Lnge des Suchtextes?
            If Len(varFound) > Len(strSearch) Then
                ' nur dann den gefundenen Text in die Textbox kopieren
                .Text = varFound
            End If
            ' den Cursor wieder an die Position setzen, an der er stand
            .SelStart = lngStart
            ' nur den letzten Teil des Textes (den man nicht eingegeben hat)
            ' markieren
            If Len(varFound) >= lngStart Then
                .SelLength = Len(varFound) - lngStart
            Else
                .SelLength = Len(varFound)
            End If
        End If
    End With
    
fnSearchInput_Exit:
    fnSearchInput = lngID
    Exit Function

fnSearchInput_Error:
    Select Case Err
        Case 91     ' Object not set
            Resume fnSearchInput_Exit
        Case Else
            Err.Raise Err.Number, cSource, Err.Description
            Resume fnSearchInput_Exit
    End Select
End Function

'---------------------------------------------------------------------------------------
' Procedure   : RaiseError
' Date        : 21.04.2012
' Last Change : 21.04.2012
' Purpose     : Vereinfachung von Err.Raise innerhalb des Klassenmoduls
' Parameters  : intError: Einer der Fehler aus EnmErrorsCCAutoComplete
'               strSource: ErrorSource-Name der aufrufenden Funktion fr Fehlerausgaben
' Returns     :  -
'---------------------------------------------------------------------------------------
'
Private Sub RaiseError(intError As EnmErrorsCCAutoComplete, strSource As String)
    Err.Raise intError + vbObjectError, strSource, Me.ErrText(intError)
End Sub

'---------------------------------------------------------------------------------------
' Procedure   : prv_ctlTextbox_GotFocus
' Date        : 21.04.2012
' Last Change : 21.04.2012
' Purpose     : GotFocus-Event in der AutoComplete-Textbox
'---------------------------------------------------------------------------------------
'
Private Sub prv_ctlTextbox_GotFocus()
    On Error Resume Next
    prv_varOldValue = prv_ctlTextbox
    If Not prv_rsSearch Is Nothing Then
        prv_rsSearch.Close
        Set prv_rsSearch = Nothing
    End If
    Set prv_rsSearch = CurrentDb.OpenRecordset(prv_strSQL)
End Sub

'---------------------------------------------------------------------------------------
' Procedure   : prv_ctlTextbox_KeyUp
' Date        : 21.04.2012
' Last Change : 21.04.2012
' Purpose     : KeyUp-Event in der AutoComplete-Textbox
'---------------------------------------------------------------------------------------
'
Private Sub prv_ctlTextbox_KeyUp(KeyCode As Integer, Shift As Integer)
    Dim lngID As Long
    Dim lngSelStartBuffer As Long
    Dim lngSelLengthBuffer As Long

   On Error GoTo prv_ctlTextbox_KeyUp_Error

    lngSelStartBuffer = prv_ctlTextbox.SelStart
    lngSelLengthBuffer = prv_ctlTextbox.SelLength

    lngID = fnSearchInput(KeyCode, Shift)
        Select Case lngID
            Case Is > 0
                SetAdditionalTextboxes lngID
            Case 0
                SetAdditionalTextboxes 0
            Case -1
                ' Sondertasten gedrckt, nichts machen
        End Select

    With prv_ctlTextbox
        .SelStart = lngSelStartBuffer
        ' nur den letzten Teil des Textes (den man nicht eingegeben hat)
        ' markieren
        If Len(.Text) >= lngSelStartBuffer Then
            .SelLength = Len(.Text) - lngSelStartBuffer
        Else
            .SelLength = Len(.Text)
        End If
    End With

prv_ctlTextbox_KeyUp_Exit:
    Exit Sub

prv_ctlTextbox_KeyUp_Error:
    Resume prv_ctlTextbox_KeyUp_Exit

End Sub

'---------------------------------------------------------------------------------------
' Procedure   : prv_ctlTextbox_LostFocus
' Date        : 21.04.2012
' Last Change : 21.04.2012
' Purpose     : LostFocus-Event in der AutoComplete-Textbox
'---------------------------------------------------------------------------------------
'
Private Sub prv_ctlTextbox_LostFocus()
    Dim lngID As Long

   On Error GoTo prv_ctlTextbox_LostFocus_Exit

    ' Folgende Variante fr gebundene Felder verwenden:
    'If prv_ctlTextbox.Value <> prv_ctlTextbox.OldValue Then
    ' fr ungebundene so:
    If prv_ctlTextbox.Value <> prv_varOldValue Then
        ' beim Verlassen Eingabe nochmal berprfen und Werte entsprechend einstellen
        lngID = fnSearchInput(0, 0)
        Select Case lngID
            Case Is > 0
                SetAdditionalTextboxes lngID
            Case 0
                prv_ctlTextbox = Null
                SetAdditionalTextboxes 0
            Case -1
                ' Sondertasten gedrckt, nichts machen
        End Select

        ' Recordset der Suchfunktion schlieen
        If Not prv_rsSearch Is Nothing Then
            prv_rsSearch.Close
            Set prv_rsSearch = Nothing
        End If
    End If

prv_ctlTextbox_LostFocus_Exit:
    Exit Sub

prv_ctlTextbox_LostFocus_Error:
    Resume prv_ctlTextbox_LostFocus_Exit
End Sub

'---------------------------------------------------------------------------------------
' Procedure   : SetAdditionalTextboxes
' Date        : 22.04.2012
' Last Change : 22.04.2012
' Purpose     : Falls zustzliche Textboxen hinzugefgt wurden, wird deren Inhalt hier
'               anhand der ID und des geffneten Recordsets gesetzt
' Parameters  : lngID: Die ID des aktuell gefundenen Datensatzes, falls 0, werden die Felder gelscht
' Returns     :  -
'---------------------------------------------------------------------------------------
'
Private Sub SetAdditionalTextboxes(lngID As Long)
    Dim ctl As Access.TextBox
    Dim varFieldName As Variant
    
    If Not prv_colAdditionalFields_Names Is Nothing Then
        For Each varFieldName In prv_colAdditionalFields_Names
            varFieldName = Mid(varFieldName, 2, Len(varFieldName) - 2)
            If lngID = 0 Then
                prv_colAdditionalFields(varFieldName).Value = Null
            Else
                If Not prv_rsSearch Is Nothing Then
                    If Not (prv_rsSearch.EOF And prv_rsSearch.BOF) Then
                        prv_colAdditionalFields(varFieldName).Value = prv_rsSearch.Fields(varFieldName)
                    End If
                End If
            End If
        Next
    End If
End Sub

' ######################################################################################
' --------------------------------------------------------------------------------------
' ------------------------------ Constructor / Destructor ------------------------------
' --------------------------------------------------------------------------------------
' ######################################################################################

Private Sub Class_Initialize()
    Set prv_colAdditionalFields = New Collection
    Set prv_colAdditionalFields_Names = New Collection
    prv_intLanguage = enmCCAutoCompleteLanguage_EN  ' Default-Sprache fr Fehlermeldungen
    
    ReDim prv_strErrors_DE(enmErrorsCCAutoComplete_Last - 1)
    ReDim prv_strErrors_EN(enmErrorsCCAutoComplete_Last - 1)

    prv_strErrors_DE(EnmErrorsCCAutoComplete.enmErrorsCCAutoComplete_UseInitAutoCompleteFirst) = cError_UseInitAutoCompleteFirst_DE
    prv_strErrors_DE(EnmErrorsCCAutoComplete.enmErrorsCCAutoComplete_AddTB_MissingFieldName) = cError_AddTB_MissingFieldName_DE
    prv_strErrors_DE(EnmErrorsCCAutoComplete.enmErrorsCCAutoComplete_AddTB_MissingTextboxReference) = cError_AddTB_MissingTextboxReference_DE
    prv_strErrors_DE(EnmErrorsCCAutoComplete.enmErrorsCCAutoComplete_AddTB_NotAnUnboundTextbox) = cError_AddTB_NotAnUnboundTextbox_DE
    prv_strErrors_DE(EnmErrorsCCAutoComplete.enmErrorsCCAutoComplete_AddTB_TextboxAlreadyInserted) = cError_AddTB_TextboxAlreadyInserted_DE
    prv_strErrors_DE(EnmErrorsCCAutoComplete.enmErrorsCCAutoComplete_AddTB_TextboxEqualToACTextbox) = cError_AddTB_TextboxEqualToACTextbox_DE
    prv_strErrors_DE(EnmErrorsCCAutoComplete.enmErrorsCCAutoComplete_AddTB_WrongFieldName) = cError_AddTB_WrongFieldName_DE
    prv_strErrors_DE(EnmErrorsCCAutoComplete.enmErrorsCCAutoComplete_ErrorNumberDoesntExist) = cError_ErrorNumberDoesntExist_DE
    prv_strErrors_DE(EnmErrorsCCAutoComplete.enmErrorsCCAutoComplete_MissingAutoCompleteTextboxReference) = cError_MissingAutoCompleteTextboxReference_DE
    prv_strErrors_DE(EnmErrorsCCAutoComplete.enmErrorsCCAutoComplete_MissingIDFieldName) = cError_MissingIDFieldName_DE
    prv_strErrors_DE(EnmErrorsCCAutoComplete.enmErrorsCCAutoComplete_MissingTableName) = cError_MissingTableName_DE
    prv_strErrors_DE(EnmErrorsCCAutoComplete.enmErrorsCCAutoComplete_MissingTextFieldName) = cError_MissingTextFieldName_DE
    prv_strErrors_DE(EnmErrorsCCAutoComplete.enmErrorsCCAutoComplete_WrongIDFieldName) = cError_WrongIDFieldName_DE
    prv_strErrors_DE(EnmErrorsCCAutoComplete.enmErrorsCCAutoComplete_WrongTableName) = cError_WrongTableName_DE
    prv_strErrors_DE(EnmErrorsCCAutoComplete.enmErrorsCCAutoComplete_WrongTextFieldName) = cError_AddTB_MissingFieldName_DE

    prv_strErrors_EN(EnmErrorsCCAutoComplete.enmErrorsCCAutoComplete_UseInitAutoCompleteFirst) = cError_UseInitAutoCompleteFirst_EN
    prv_strErrors_EN(EnmErrorsCCAutoComplete.enmErrorsCCAutoComplete_AddTB_MissingFieldName) = cError_AddTB_MissingFieldName_EN
    prv_strErrors_EN(EnmErrorsCCAutoComplete.enmErrorsCCAutoComplete_AddTB_MissingTextboxReference) = cError_AddTB_MissingTextboxReference_EN
    prv_strErrors_EN(EnmErrorsCCAutoComplete.enmErrorsCCAutoComplete_AddTB_NotAnUnboundTextbox) = cError_AddTB_NotAnUnboundTextbox_EN
    prv_strErrors_EN(EnmErrorsCCAutoComplete.enmErrorsCCAutoComplete_AddTB_TextboxAlreadyInserted) = cError_AddTB_TextboxAlreadyInserted_EN
    prv_strErrors_EN(EnmErrorsCCAutoComplete.enmErrorsCCAutoComplete_AddTB_TextboxEqualToACTextbox) = cError_AddTB_TextboxEqualToACTextbox_EN
    prv_strErrors_EN(EnmErrorsCCAutoComplete.enmErrorsCCAutoComplete_AddTB_WrongFieldName) = cError_AddTB_WrongFieldName_EN
    prv_strErrors_EN(EnmErrorsCCAutoComplete.enmErrorsCCAutoComplete_ErrorNumberDoesntExist) = cError_ErrorNumberDoesntExist_EN
    prv_strErrors_EN(EnmErrorsCCAutoComplete.enmErrorsCCAutoComplete_MissingAutoCompleteTextboxReference) = cError_MissingAutoCompleteTextboxReference_EN
    prv_strErrors_EN(EnmErrorsCCAutoComplete.enmErrorsCCAutoComplete_MissingIDFieldName) = cError_MissingIDFieldName_EN
    prv_strErrors_EN(EnmErrorsCCAutoComplete.enmErrorsCCAutoComplete_MissingTableName) = cError_MissingTableName_EN
    prv_strErrors_EN(EnmErrorsCCAutoComplete.enmErrorsCCAutoComplete_MissingTextFieldName) = cError_MissingTextFieldName_EN
    prv_strErrors_EN(EnmErrorsCCAutoComplete.enmErrorsCCAutoComplete_WrongIDFieldName) = cError_WrongIDFieldName_EN
    prv_strErrors_EN(EnmErrorsCCAutoComplete.enmErrorsCCAutoComplete_WrongTableName) = cError_WrongTableName_EN
    prv_strErrors_EN(EnmErrorsCCAutoComplete.enmErrorsCCAutoComplete_WrongTextFieldName) = cError_AddTB_MissingFieldName_EN
End Sub

Private Sub Class_Terminate()
    Set prv_colAdditionalFields = Nothing
    Set prv_colAdditionalFields_Names = Nothing
End Sub

