VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsCCSQL_Condition"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Compare Database
Option Explicit

'---------------------------------------------------------------------------------------
' Module      : clsCCSQL_Condition
' Version     : 1.0
' Author      : Christian Coppes
' Date        : 04.10.2012
' Last Change : 28.10.2012
' Purpose     : Saves conditions for "WHERE" or "HAVING"
'---------------------------------------------------------------------------------------

' ######################################################################################
' --------------------------------------------------------------------------------------
' -------------------------------------- Constants -------------------------------------
' --------------------------------------------------------------------------------------
' ######################################################################################

Private Const cMODULENAME As String = "clsCCSQL_Condition"

' ######################################################################################
' --------------------------------------------------------------------------------------
' ----------------------------------- Class Variables ----------------------------------
' --------------------------------------------------------------------------------------
' ######################################################################################

Private prv_strFieldName As String
Private prv_strFieldValue As String

' ######################################################################################
' --------------------------------------------------------------------------------------
' ------------------------------------- Properties -------------------------------------
' --------------------------------------------------------------------------------------
' ######################################################################################

Public TestFieldExists As Boolean
Public UseSquareBrackets As Boolean

Public Operation As String                  ' contains "WHERE", "AND", "OR" and so on
Private prv_strCondition As String
Public HavingCondition As Boolean           ' True = HAVING, False = WHERE
Public LogicGroupNo As Integer

'---------------------------------------------------------------------------------------
' Property    : FieldName
' Access Meth.: Read/Write
' Date        : 04.10.2012
' Purpose     : Get or set the name of the field to compare
' Returns     : str - String: Fieldname with or without square brackets depending on "UseSquareBrackets"
'---------------------------------------------------------------------------------------
'
Public Property Get FieldName() As String
    ' optionally add square brackets if "UseSquareBrackets" is true
    FieldName = IIf(Me.UseSquareBrackets, "[", "") & prv_strFieldName & IIf(Me.UseSquareBrackets, "]", "")
End Property
Public Property Let FieldName(strFieldName As String)
    ' Field names will always be saved without square brackets
    prv_strFieldName = strFieldName
    If Left(prv_strFieldName, 1) = "[" Then prv_strFieldName = Right(prv_strFieldName, Len(prv_strFieldName) - 1)
    If Right(prv_strFieldName, 1) = "]" Then prv_strFieldName = Left(prv_strFieldName, Len(prv_strFieldName) - 1)
End Property

'---------------------------------------------------------------------------------------
' Property    : FieldValue
' Access Meth.: Read/Write
' Date        : 04.10.2012
' Purpose     : Get or set the value which should be compared
' Returns     : str - String
'---------------------------------------------------------------------------------------
'
Public Property Get FieldValue(Optional strDecimalPoint As String = ",") As String
    FieldValue = prv_strFieldValue
End Property
Public Property Let FieldValue(Optional strDecimalPoint As String = ",", ByVal strValue As String)
    If IsDate(strValue) Then
        prv_strFieldValue = "#" & Format(strValue, "mm\/dd\/yyyy") & " " & Hour(strValue) & ":" & Minute(strValue) & ":" & Second(strValue) & "#"
    ElseIf IsNumeric(strValue) Then
        If strDecimalPoint = "," Then
            strValue = Replace(Replace(strValue, ".", ""), ",", ".")
        ElseIf strDecimalPoint = "." Then
            strValue = Replace(strValue, ",", "")
        End If
        prv_strFieldValue = strValue
    Else
        If Trim(strValue) <> "NULL" Then
            prv_strFieldValue = "'" & strValue & "'"
        Else
            prv_strFieldValue = "NULL"
        End If
    End If
End Property

'---------------------------------------------------------------------------------------
' Property    : Condition
' Access Meth.: Read/Write
' Date        : 04.10.2012
' Purpose     : Contains the compare condition like ">", "=" and so on
' Returns     : str - String
'---------------------------------------------------------------------------------------
'
Public Property Get Condition() As String
    Condition = prv_strCondition
End Property
Public Property Let Condition(strCondition As String)
    prv_strCondition = " " & Trim(strCondition) & " "
End Property

'---------------------------------------------------------------------------------------
' Property    : ConditionString
' Access Meth.: Read Only
' Date        : 04.10.2012
' Purpose     : Returns a complete condition string like "WHERE A=1" depending on the values in the object
' Returns     : str - String
'---------------------------------------------------------------------------------------
'
Public Property Get ConditionString() As String
    Dim strResult As String
    
    Select Case Me.Operation
        Case "AND", "OR ", "NOT", "ANDbegin", "OR begin", "NOTbegin"
            strResult = " " & Left(Me.Operation, 3) & " "
            If Right(Me.Operation, 5) = "begin" Then strResult = strResult & "("
            strResult = strResult & Me.FieldName & Me.Condition
        Case "ANDend", "OR end", "NOTend"
            strResult = ") "
        Case "WHERE"
            strResult = " WHERE " & Me.FieldName & Me.Condition
        Case "HAVING"
            strResult = " HAVING " & Me.FieldName & Me.Condition
    End Select
    If Right(Me.Operation, 3) <> "end" Then
        strResult = strResult & Me.FieldValue
    End If
    ConditionString = strResult
End Property

' ######################################################################################
' --------------------------------------------------------------------------------------
' ------------------------------ Constructor / Destructor ------------------------------
' --------------------------------------------------------------------------------------
' ######################################################################################

Private Sub Class_Initialize()
    UseSquareBrackets = True
    TestFieldExists = True
End Sub
